 aR w * mP9      h	 oP    nSystem-wide$NOLIST

NAME  ResourceRoutines

$INCLUDE (ErrCnsts~Inc~)

CGROUP GROUP CODE
DGROUP GROUP DATA

PUBLIC InitResourceVariables
PUBLIC RscOpenResourceFile, RscCloseResourceFile
PUBLIC RscGetResource, RscGetResourceCopy, RscFreeResource
PUBLIC RscGetResourceString, RscGetResourceStringCopy

EXTRN  DosAlloc: NEAR, DosFree: NEAR, RetDosAndIntelPtrs: NEAR


DATA SEGMENT  PUBLIC 'DATA'
DATA ENDS

CODE SEGMENT  PUBLIC 'CODE'
	ASSUME CS:CGROUP

ExeHeaderType STRUC
  ehSignature    DW ?
  ehRemainder    DW ?
  ehBlocks512    DW ?
  ehNumFixups    DW ?
  ehPgmStart     DW ?
  ehMinAlloc     DW ?
  ehMaxAlloc     DW ?
  ehInitialSS    DW ?
  ehInitialSP    DW ?
  ehChecksum     DW ?
  ehInitialIP    DW ?
  ehInitialCS    DW ?
  ehFixupsOff    DW ?
  ehNumOverlays  DW ?
ExeHeaderType ENDS

RscHeaderType STRUC
  rhSignature    DW ?
  rhLenRscTable  DW ?
  rhNumResources DW ?
  rhFutureUse    DW 5 DUP (?)
RscHeaderType ENDS

RscStrHdrType STRUC
  rsSignature    DW ?
  rsNumStrings   DW ?
  rsFutureUse    DW 6 DUP (?)
  rsOffsetBase   DW ?
RscStrHdrType ENDS

RscEntryType STRUC
  reRscID        DW ?
  reRscType      DW ?
  reRscLength    DW ?
  reRscFlags     DW ?
  reRscFilePos   DD ?
  reRscsAddr     DD ?
RscEntryType ENDS

preLoadFlagBit  EQU 1

maxRscFilesOpen EQU 3

rscFilesOpen    DB 0
resourceEntrs   DW maxRscFilesOpen DUP (0)
resourceConns   DW maxRscFilesOpen DUP (?)
resourceAddrs   DW maxRscFilesOpen DUP (?)

headerBfr       RscHeaderType <>
$EJECT

; InitResourceVariables: PROCEDURE;

; This initialize resource variables.  It has to be called, because once a
; program is TSR'd, more than one program can call it and things have to be
; re-initialized for each program.  This is called by MniInitialize.

InitResourceVariables PROC NEAR
	PUSH	CS
	POP	ES
	LEA	DI, CS:resourceEntrs
	MOV	CX, maxRscFilesOpen
	XOR	AX, AX
	CLD
	REP	STOSW	; Init resourceEntrs to 0
	MOV	CS:rscFilesOpen, AL	; Init rscFilesOpen to 0
	RET
InitResourceVariables ENDP
$EJECT

; RscOpenResourceFile: PROCEDURE (pRscFilename, pError) WORD;

; ZZZZ- Haven't done any of the preload options, yet !!!

pRscFilename EQU DWORD PTR [BP+10]
pError       EQU DWORD PTR [BP+6]

RscOpenResourceFile PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

CheckForFullRscTable:
	MOV	AX, eTooManyResourceConns
	CMP	CS:rscFilesOpen, maxRscFilesOpen
	JNE	OpenResourceFile	; Open file if more space in table
	JMP	RscOpenRscFileErrorRet	; Else return w/error

OpenResourceFile:
	LDS	DX, pRscFilename
	MOV	AX, 3D00H	; Open file for read access only
	INT	21H	; Call MsDos
	JNC	ReadRscFileExeHeader	; Read Exe header next if no header
	JMP	RscOpenRscFileErrorRet	; Else return w/error

ReadRscFileExeHeader:
	XCHG	BX, AX	; Conn in BX for other file system calls

	PUSH	CS
	POP	DS
	LEA	DX, headerBfr.ehSignature
	MOV	CX, SIZE RscHeaderType	; Read size of rsrc header (in case it is)
	MOV	AH, 3FH	; Read from a file
	INT	21H	; Call MsDos
	JC	RscOpenRscFileCloseRetHop

	CMP	AX, CX	; If read all of the bytes
	JE	ValidateExeHeader	; then validate the Exe header
	JMP	RscOpenRscFileInvFileRet	; Else return w/error

ValidateExeHeader:
	CMP	DS:headerBfr.ehSignature, 'ZM'	; (CS=DS at this point)
	JNE	ValidateResourceHeader	; Might be resource only file if not Exe

FindStartOfResourceInfo:
	MOV	CX, DS:headerBfr.ehRemainder	; (CS=DS at this point)
	MOV	AX, DS:headerBfr.ehBlocks512	; (CS=DS at this point)
	JCXZ	BlockOn512Boundary

	DEC	AX

BlockOn512Boundary:
	MOV	DX, 512	; Resources start at
	MUL	DX	; (blocks512 - 1) * 512 + remainder
	ADD	AX, CX
	ADC	DX, 0
	ADD	AX, 15	; Round up to next 16 byte block in file
	ADC	DX, 0
	AND	AX, 0FFF0H

SeekToStartOfResourceInfo:
	XCHG	DX, AX	; Result of multiply is in DX:AX
	XCHG	CX, AX	; Seek requires seek position in CX:DX
	MOV	AX, 4200H	; Seek to this position from file beginning
	INT	21H	; Call MsDos
	JC	RscOpenRscFileCloseRetHop

ReadResourceHeader:
;	PUSH	CS
;	POP	DS	; This was set above
	LEA	DX, headerBfr.rhSignature
	MOV	CX, SIZE RscHeaderType	; Read in header of resource table of contents
	MOV	AH, 3FH	; Read from a file
	INT	21H	; Call MsDos
	JC	RscOpenRscFileCloseRetHop

	CMP	AX, CX	; If didn't read all of the bytes
	JNE	RscOpenRscFileInvFileRet	; then must be wrong resource file format

ValidateResourceHeader:
	CMP	DS:headerBfr.rhSignature, 'HR'
	JNE	RscOpenRscFileInvFileRet	; Rsc header must begin w/ 'RH' signature

	MOV	CX, DS:headerBfr.rhNumResources	; (DS=CS at this point)
	JCXZ	RscOpenRscFileInvFileRet	; Rsc header must not have zero entries

AllocRscTableOfContentsBlock:
	MOV	DX, BX	; Save file conn in DX
	MOV	BX, DS:headerBfr.rhLenRscTable; (DS=CS at this point)
	MOV	CX, BX	; Save length in CX
	ADD	BX, 15
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1	; Allocate by paragraphs
	CALL	DosAlloc	; Interface call to Int21, fnc 48h
	MOV	BX, DX	; Restore file conn from DX
	JNC	ReadResourceTableOfContents

RscOpenRscFileCloseRetHop:
	JMP	RscOpenRscFileCloseRet

ReadResourceTableOfContents:
	MOV	DS, AX
	XOR	DX, DX
;	MOV	CX, CS:headerBfr.rhLenRscTable; Set / saved above
	MOV	AH, 3FH	; Read from a file
	INT	21H	; Call MsDos
	JC	FreeTocBlockAfterError

	CMP	AX, CX	; If read all of the bytes
	JE	RscOpenRscFileStoreInfo	; then store resource file info in table

	MOV	AX, eInvalidResourceFile

FreeTocBlockAfterError:
	XCHG	CX, AX	; Save error
	PUSH	DS
	POP	ES
	CALL	DosFree	; Interface call to Int21, fnc 49h
	XCHG	AX, CX	; Restore error
	JMP	SHORT RscOpenRscFileCloseRet

RscOpenRscFileStoreInfo:
	PUSH	CS
	POP	ES
	LEA	DI, CS:resourceEntrs
	MOV	CX, maxRscFilesOpen
	ADD	DI, CX
	ADD	DI, CX
	XOR	AX, AX
	STD
	REPNZ SCASW
	MOV	DI, CX
	SHL	DI, 1
	CLD
	MOV	AX, CS:headerBfr.rhNumResources	; Get number of resources in this file
	MOV	CS:resourceConns[DI], BX	; Store the connection
	MOV	CS:resourceAddrs[DI], DS	; Store the address of resource contents
	MOV	CS:resourceEntrs[DI], AX	; Store the number of resource in this file
	INC	CS:rscFilesOpen
	XOR	AX, AX
	JMP	SHORT RscOpenRscFileRet

RscOpenRscFileInvFileRet:
	MOV	AX, eInvalidResourceFile

RscOpenRscFileCloseRet:
	XCHG	CX, AX	; Save error return in CX
	MOV	AH, 3EH	; Close a file connection
	INT	21H	; Call MsDos
	XCHG	AX, CX	; Restore error return from CX

RscOpenRscFileErrorRet:
	MOV	CX, -1	; Return (invalid resFileID)

RscOpenRscFileRet:
	LES	DI, pError
	STOSW

	XCHG	AX, CX	; Return (resFileID)

	POP	BP
	POP	DS
	RET	8
RscOpenResourceFile ENDP

PURGE pRscFilename, pError
$EJECT

; RscCloseResourceFile: PROCEDURE (resFileID, pError);

resFileID    EQU  WORD PTR [BP+10]
pError       EQU DWORD PTR [BP+6]

RscCloseResourceFile PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	MOV	AX, eInvalidResourceFile	; Error may be eInvalidResourceFile
	MOV	SI, resFileID	; If resource ID is
	CMP	SI, maxRscFilesOpen	; out of range of table
	JAE	RscCloseRscFileRet	; then return error

	XOR	AX, AX	; error = 0; null conn = 0
	SHL	SI, 1	; Index into word array
	MOV	CX, CS:resourceEntrs[SI]	; Get number of resources in this table
	JCXZ	RscCloseRscFileRet	; If zero then file must already be closed

	MOV	BX, CS:resourceConns[SI]	; Get connection to resource file
	MOV	DS, CS:resourceAddrs[SI]	; Get address of resource table of contents

	MOV	CS:resourceConns[SI], AX	; resourceConns[resFileID] = null conn
	MOV	CS:resourceAddrs[SI], AX	; resourceAddrs[resFileID] = 0
	MOV	CS:resourceEntrs[SI], AX	; resourceEntrs[resFileID] = 0

	MOV	AH, 3EH	; Close a file connection
	INT	21H	; Call MsDos
	JC	RscCloseRscFileRet	; Return (error)

	XOR	SI, SI	; index starts at 0

FreeLoadedRscsLoop:
	LES	AX, DS:[SI].reRscsAddr	; Get pointer (in RAM) to this resource
	MOV	AX, ES	; If this resource has
	OR	AX, AX	; not been read into memory
	JZ	FreeLoadedRscsLoopNext	; then don't need to free it

	CALL	DosFree	; Interface call to Int21, fnc 49h
	JC	RscCloseRscFileRet	; Return (error)
	
FreeLoadedRscsLoopNext:
	ADD	SI, SIZE RscEntryType	; index to next entry
	LOOP	FreeLoadedRscsLoop	; check next entry if not done

FreeResourceHeader:
	PUSH	DS
	POP	ES	; Now free the resource table of contents
	CALL	DosFree	; Interface call to Int21, fnc 49h
	JC	RscCloseRscFileRet	; Return (error)

	XOR	AX, AX	; Error = 0
	DEC	CS:rscFilesOpen

RscCloseRscFileRet:
	LES	DI, pError
	STOSW	; error = (value in AX)

	POP	BP
	POP	DS
	RET	6
RscCloseResourceFile ENDP

PURGE resFileID, pError
$EJECT


; RscGetResource: PROCEDURE (resourceID, pLenRsc, pError) PTR;

resourceID   EQU  WORD PTR [BP+14]
pLenRsc      EQU DWORD PTR [BP+10]
pError       EQU DWORD PTR [BP+6]

copyResource EQU  BYTE PTR [BP-2]

RscGetResource LABEL NEAR
	MOV	AL, 0	; No, don't copy resource
	JMP	SHORT RscGetResourceRtn

RscGetResourceCopy LABEL NEAR
	MOV	AL, 1	; Yes, copy resource

RscGetResourceRtn PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	PUSH	AX	; copyResource = TRUE/FALSE

	MOV	CX, maxRscFilesOpen	; max num of resource files/data to search

RscFileTableLoopTop:
	PUSH	CX	; save current resource files index
	MOV	SI, maxRscFilesOpen
	SUB	SI, CX
	SHL	SI, 1	; index into word arrays

	MOV	CX, CS:resourceEntrs[SI]	; If number of resources in this file
	JCXZ	RscFileTableLoopNext	; is zero then check next resource file entry

	MOV	BX, CS:resourceConns[SI]	; Connection for this resource
	MOV	DS, CS:resourceAddrs[SI]	; Address of this resource files TOC
	XOR	SI, SI	; index starts at 0

RscTblOfContsLoopTop:
	MOV	AX, DS:[SI].reRscID	; Get resource number of this resource
	CMP	AX, resourceID	; If this is the resource searched for
	JNE	RscTblOfContsLoopNext	; then stop looking for it

	POP	CX	; Clear stack
	JMP	SHORT RscFoundCheckIfInRam

RscTblOfContsLoopNext:
	ADD	SI, SIZE RscEntryType	; index to next entry
	LOOP	RscTblOfContsLoopTop	; Check next resource for a match

RscFileTableLoopNext:
	POP	CX	; Restore current resource files index
	LOOP	RscFileTableLoopTop
	MOV	AX, eResourceNotFound	; Return error of resource not found
	JMP	RscGetResourceError	; if all were searched and it wasn't found

RscFoundCheckIfInRam:
	MOV	CX, DS:[SI].reRscLength
	LES	DI, pLenRsc
	MOV	ES:[DI], CX	; lenRsc = reRscLen

	LES	DI, DS:[SI].reRscsAddr	; Get address of resource data in ram
	MOV	AX, ES	; If the resource data
	OR	AX, AX	; is not in ram
	JZ	RscReadResourceFromFile	; then read it from the file

	MOV	BX, DI	; Return ptr in ES:BX
	TEST	copyResource, 1	; If this is RscGetResource
	JZ	RscGetResourceExit	; then return ptr to the resource

	MOV	BX, CX	; Length of resource
	ADD	BX, 15	; Round up to next block size
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1	; Allocate in 16 byte blocks
	CALL	DosAlloc	; Interface call to Int21, fnc 48h
	JC	RscGetResourceError

	MOV	ES, AX	; Set segment for destination
	XOR	BX, BX	; Return pointer in ES:BX
	MOV	DI, BX	; Offset for destination of copy
	LDS	SI, DS:[SI].reRscsAddr	; Source is resource in RAM
	CLD
	SHR	CX, 1
	REP	MOVSW
	JNC	RscGetResourceExit	; done if it was an even number of bytes

	MOVSB
	JMP	SHORT RscGetResourceExit	; return ptr copy of the resource

RscReadResourceFromFile:
	PUSH	BX	; Save file conn
	MOV	BX, CX	; Get length of resource
	ADD	BX, 15	; Round up to next block size
	MOV	CL, 4	; Divide by sixteen to
	SHR	BX, CL	; convert num bytes to num blocks
	CALL	DosAlloc	; Interface call to Int21, fnc 48h
	POP	BX	; Restore file conn
	JC	RscGetResourceError

	MOV	ES, AX	; Save address of memory block in ES

	MOV	DX, WORD PTR DS:[SI+0].reRscFilePos
	MOV	CX, WORD PTR DS:[SI+2].reRscFilePos
	MOV	AX, 4200H	; Seek to this position from file beginning
	INT	21H	; Call MsDos
	JC	RscReadResourceError

	MOV	CX, DS:[SI].reRscLength	; Length of the read
	MOV	DI, DS	; Save segment of resource T.O.C. in DI
	PUSH	ES
	POP	DS
	XOR	DX, DX	; Destination of read
	MOV	AH, 3FH	; Read from a file
	INT	21H	; Call MsDos
	JC	RscReadResourceError

	CMP	AX, CX	; Check for complete read / end of file
	MOV	AX, eInvalidResourceFile
	JNE	RscReadResourceError

	XOR	BX, BX	; Address of allocated block is ES:0
	TEST	copyResource, 1	; If this is RscGetResourceCopy
	JNZ	RscGetResourceExit	; then just return ptr to the resource

	MOV	DS, DI	; Point to resource T.O.C. again
	MOV	WORD PTR DS:[SI+0].reRscsAddr, BX
	MOV	WORD PTR DS:[SI+2].reRscsAddr, ES
	JMP	SHORT RscGetResourceExit

RscReadResourceError:
	PUSH	AX	; Save error
	CALL	DosFree	; Interface call to Int21, fnc 49h
	POP	AX	; Restore error

RscGetResourceError:
	XOR	BX, BX
	MOV	ES, BX	; Return ("C"-like null ptr)
	JMP	RscGetResourceRet

RscGetResourceExit:
	XOR	AX, AX	; Error = 0

RscGetResourceRet:
	LDS	SI, pError
	MOV	DS:[SI], AX	; error = (value in AX)

	CALL	RetDosAndIntelPtrs	; Return ptr in ES:BX and DX:AX

	MOV	SP, BP
	POP	BP
	POP	DS
	RET	10
RscGetResourceRtn ENDP

PURGE resourceID, pLenRsc, pError
PURGE copyResource
$EJECT

; RscFreeResource: PROCEDURE (rscAddr, pError);

rscAddr      EQU DWORD PTR [BP+10]
pError       EQU DWORD PTR [BP+6]

RscFreeResource PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	MOV	CX, maxRscFilesOpen	; max num of resource files/data to search

RscFreeFileTableLoopTop:
	PUSH	CX	; save current resource files index
	MOV	SI, maxRscFilesOpen
	SUB	SI, CX
	SHL	SI, 1	; index into word arrays

	MOV	CX, CS:resourceEntrs[SI]	; Number of resources in this file
	JCXZ	RscFreeFileTableLoopNext	; Skip it if no entries

	MOV	DS, CS:resourceAddrs[SI]	; Address of this resource files TOC
	XOR	SI, SI	; index starts at 0

RscFreeTblOfContsLoopTop:
	LES	BX, DS:[SI].reRscsAddr	; Get resource address in ram
	MOV	AX, ES	; If resource has not been read into ram
	JZ	RscFreeTblOfContsLoopNext; then check to see if it is the next one

	CMP	AX, WORD PTR rscAddr + 2	; If this is not the rsc addr searched for
	JNE	RscFreeTblOfContsLoopNext; then check to see if it is the next one

	CMP	BX, WORD PTR rscAddr + 0	; If this is not the rsc addr searched for
	JNE	RscFreeTblOfContsLoopNext; then check to see if it is the next one

	POP	CX	; Clear stack
	JMP	SHORT RscFoundFreeIt

RscFreeTblOfContsLoopNext:
	ADD	SI, SIZE RscEntryType	; index to next entry
	LOOP	RscFreeTblOfContsLoopTop	; Check next resource for a match

RscFreeFileTableLoopNext:
	POP	CX	; Restore current resource files index
	LOOP	RscFreeFileTableLoopTop

	MOV	AX, eResourceNotFound	; Return error of resource not found
	JMP	SHORT RscFreeResourceRet	; if all were searched and it wasn't found

RscFoundFreeIt:
	CALL	DosFree	; Interface call to Int21, fnc 49h
	JC	RscFreeResourceRet

	XOR	AX, AX	; error = 0

RscFreeResourceRet:
	LES	DI, pError
	STOSW	; error = (value in AX)

	POP	BP
	POP	DS
	RET	8
RscFreeResource ENDP

PURGE rscAddr, pError
$EJECT

; RscGetResourceString: PROCEDURE (pStrRscData, index, pLength): Pointer;

pStrRscData EQU DWORD PTR [BP+12]
index       EQU  WORD PTR [BP+10]
pLength     EQU DWORD PTR [BP+6]

RscGetResourceString PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	LDS	SI, pStrRscData
	CMP	DS:[SI].rsSignature, 'SS'; If the string resource buffer does not have
	JNE	RscGetRscStrError	; a valid signature then RETURN (0)

	MOV	BX, index
	DEC	BX	; If the string index is out of range for
	CMP	BX, DS:[SI].rsNumStrings	; the number of entries in this string
	JA	RscGetRscStrError	; resource then RETURN (0)

	SHL	BX, 1	; Make into index to word array
	MOV	CX, DS:[SI+BX+2].rsOffsetBase
	MOV	BX, DS:[SI+BX].rsOffsetBase
	SUB	CX, BX	; Length of the string
	DEC	CX	; Don't count the AsciiZ terminator in length

	ADD	BX, SI
	MOV	AX, DS
	MOV	ES, AX
	JMP	SHORT RscGetRscStrRet

RscGetRscStrError:
	XOR	CX, CX
	MOV	ES, CX
	MOV	BX, CX	; RETURN (0) to indicate error

RscGetRscStrRet:
	LDS	SI, pLength
	MOV	DS:[SI], CX	; Set strLength

	CALL	RetDosAndIntelPtrs	; Return ptr in ES:BX and DX:AX

	POP	BP
	POP	DS
	RET	10
RscGetResourceString ENDP

PURGE pStrRscData, index, pLength
$EJECT

; RscGetResourceStringCopy: PROCEDURE (pStrRscData, index, pLength): Pointer;

pStrRscData EQU DWORD PTR [BP+12]
index       EQU  WORD PTR [BP+10]
pLength     EQU DWORD PTR [BP+6]

RscGetResourceStringCopy PROC NEAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP

	LES	AX, pStrRscData
	PUSH	ES
	PUSH	AX
	PUSH	index
	LES	AX, pLength
	PUSH	ES
	PUSH	AX
	CALL	RscGetResourceString	; Call RscGetResourceString

	MOV	AX, ES	; If the pointer returned by 
	OR	AX, BX	; RscGetResourceString is zero
	JZ	RscGetRscStrCopyError	; then RETURN (0); i.e. an error

	PUSH	ES
	PUSH	BX	; Save pointer to string

	LDS	SI, pLength
	MOV	CX, DS:[SI]	; Get length of the string
	INC	CX	; Include the AsciiZ terminator in copy

	MOV	BX, CX
	ADD	BX, 15	; Round up length to next paragraph size
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1
	SHR	BX, 1	; Number of paragraphs needed
	CALL	DosAlloc	; Interface call to Int21, fnc 48h
	POP	SI
	POP	DS	; Restore pointer to string
	JC	RscGetRscStrCopyError	; If error from allocate call, RETURN (0)

	MOV	ES, AX
	XOR	DI, DI
	CLD
	REP	MOVSB	; Copy string to allocated string
	XOR	BX, BX	; Offset of returned string should be zero
	JMP	SHORT RscGetRscStrCopyRet

RscGetRscStrCopyError:
	LES	DI, pLength
	XOR	AX, AX
	STOSW	; length = 0
	MOV	ES, AX
	XCHG	BX, AX	; RETURN (0)

RscGetRscStrCopyRet:
	CALL	RetDosAndIntelPtrs	; Return ptr in ES:BX and DX:AX

	POP	BP
	POP	DS
	RET	10
RscGetResourceStringCopy ENDP

PURGE pStrRscData, index, pLength


CODE ENDS

     END
